/*
 * Decompiled with CFR 0.152.
 */
package com.onlinetutorialspoint.config;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public class HibernateConnector {
    private static HibernateConnector me;
    private Configuration cfg;
    private SessionFactory factory;

    private HibernateConnector(Configuration preConfig) throws HibernateException {
        this.cfg = preConfig == null ? new Configuration() : preConfig;
        this.cfg.setProperty("hibernate.connection.driver_class", "com.mysql.jdbc.Driver");
        this.cfg.setProperty("hibernate.connection.url", "jdbc:mysql://localhost:3306/onlinetutorialspoint");
        this.cfg.setProperty("hibernate.connection.username", "chandu");
        this.cfg.setProperty("hibernate.connection.password", "123456");
        this.cfg.setProperty("hibernate.show_sql", "true");
        this.cfg.addResource("com/onlinetutorialspoint/pojo/Login.hbm.xml");
        this.cfg.addResource("com/onlinetutorialspoint/pojo/Student.hbm.xml");
        this.factory = this.cfg.buildSessionFactory();
    }

    public static synchronized HibernateConnector getInstance() throws HibernateException {
        if (me == null) {
            me = new HibernateConnector(null);
        }
        return me;
    }

    public Session getSession() throws HibernateException {
        Session session = this.factory.openSession();
        if (!session.isConnected()) {
            this.reconnect();
        }
        return session;
    }

    private void reconnect() throws HibernateException {
        this.factory = this.cfg.buildSessionFactory();
    }
}

