/*
 * Decompiled with CFR 0.152.
 */
package com.onlinetutorialspoint.dao;

import com.onlinetutorialspoint.dao.MessageDigestCheck;
import java.awt.List;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import javax.xml.bind.DatatypeConverter;

public class Communicate {
    private String serverPath = "";
    private String hostName = "";
    private int port = 80;
    public static final Integer CULTSWITCH = 1;
    public static final Integer CULTSWITCH_SERVICE = 2;
    public static final Integer ROOMTYPES = 10;
    public static final Integer DISTRIBUTOR_CREDENTIALS = 11;
    public static final Integer GDS_CODES = 12;
    private String postData = "";
    private String responseData = "";
    private boolean noHeaders = true;
    private String httpUser = "";
    private String httpPass = "";
    private boolean connectionProblems = false;
    public static int inc = 0;
    public static final int POST = 1;
    public static final int GET = 2;
    private int postMethod = 1;
    List l;
    private String authUser;
    private String authPassword;
    private boolean foundErrors = false;
    private String errorMessage;

    public boolean isFoundErrors() {
        return this.foundErrors;
    }

    public void setFoundErrors(boolean foundErrors) {
        this.foundErrors = foundErrors;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Communicate() {
    }

    private Communicate(String host, int port, String serverPath, String postData, String authUser, String authPassword) {
        this.setHostName(host);
        this.setPort(port);
        this.setServerPath(serverPath);
        this.setAuthUser(authUser);
        this.setAuthPassword(authPassword);
        if (postData != null && postData.length() > 0) {
            this.setPostData(postData);
        }
    }

    public void setAuthUser(String authUser) {
        this.authUser = authUser;
    }

    public void setAuthPassword(String authPassword) {
        this.authPassword = authPassword;
    }

    private Communicate(String host, int port, String serverPath, String postData) {
        this.setHostName(host);
        this.setPort(port);
        this.setServerPath(serverPath);
        if (postData != null && postData.length() > 0) {
            this.setPostData(postData);
        }
    }

    public Communicate getInstance(String projectType, Communicate communicate, String request, Boolean isHttpAuth, Boolean isSecureKey) {
        try {
            communicate.setHostName("backups.cultuzz.de");
            communicate.setPort(8080);
            MessageDigestCheck mv = new MessageDigestCheck();
            if (isSecureKey.booleanValue()) {
                String MD5Message1 = mv.calMsgDigest(request, projectType);
                communicate.setPostData("otaRQ=" + request + "&secure_key=" + MD5Message1);
            } else {
                communicate.setPostData("otaRQ=" + URLEncoder.encode(request, "UTF-8"));
            }
            if (isHttpAuth.booleanValue()) {
                communicate.setServerPath("/cultswitch/basic");
                communicate.doHandShake("544107", "NTQ0MTA3**MDQ=**ZTgxMTY5MDg4OWNiYWU2");
            } else {
                communicate.setServerPath("/cultswitch/processOTA");
                communicate.doHandShake();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return communicate;
    }

    public void setServerPath(String path) {
        this.serverPath = path;
    }

    public String getServerPath() {
        return this.serverPath;
    }

    public void setHostName(String name) {
        this.hostName = name;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setPostData(String postData) {
        this.postData = postData;
    }

    public String getPostData() {
        return this.postData;
    }

    public void setResponseData(String responseData) {
        this.responseData = responseData;
    }

    public String getResponseData() {
        return this.responseData;
    }

    public boolean isNoHeaders() {
        return this.noHeaders;
    }

    public void setNoHeaders(boolean headoff) {
        this.noHeaders = headoff;
    }

    public void setPostMethod(int method) {
        this.postMethod = method;
    }

    public void setUserData(String username, String password) {
        this.httpUser = username;
        this.httpPass = password;
    }

    private void authenticate(String username, String password) {
        this.setUserData(username, password);
        this.authenticate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void authenticate() {
        InputStream ins = null;
        StringBuffer response = null;
        try {
            String str;
            this.setFoundErrors(false);
            System.out.println("i am in authentication..........");
            System.out.println("httpuser...." + this.httpUser + " .........httpPass....." + this.httpPass + "  port...." + this.port);
            URL url = new URL("http://" + this.hostName + ":" + this.port + this.serverPath);
            System.out.println("url connection ........" + url);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            System.out.println("connection......" + conn);
            String userpass = this.httpUser + ":" + this.httpPass;
            String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])userpass.getBytes());
            System.out.println("basic auth......" + basicAuth);
            conn.setRequestProperty("Authorization", basicAuth);
            conn.setDoOutput(true);
            OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
            out.write(this.postData);
            out.close();
            ins = conn.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(ins));
            response = new StringBuffer("");
            while ((str = reader.readLine()) != null) {
                response.append(str).append("\r\n");
            }
            this.responseData = response.toString();
            System.out.println("done");
        }
        catch (IOException ex) {
            System.out.println("i am in IOException...." + ex);
            this.setFoundErrors(true);
            this.setErrorMessage("Failed making connection to Server!(" + this.hostName + ")");
            this.setConnectionProblems(true);
        }
        finally {
            try {
                response = null;
                ins.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.setConnectionProblems(true);
            }
        }
    }

    public void doHandShake(String username, String password) {
        this.authenticate(username, password);
    }

    public void doHandShake() {
        StringBuffer response = null;
        try {
            this.setFoundErrors(false);
            if (this.serverPath.equalsIgnoreCase("") || this.hostName.equalsIgnoreCase("")) {
                return;
            }
            InetAddress addr = InetAddress.getByName(this.hostName);
            Socket socket = new Socket(addr, this.port);
            BufferedWriter bWr = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF8"));
            bWr.write("POST " + this.serverPath + " HTTP/1.0\r\n");
            bWr.write("Host: " + this.hostName + "\r\n");
            bWr.write("Content-Length: " + this.postData.length() + "\r\n");
            bWr.write("Content-Type: application/x-www-form-urlencoded\r\n");
            bWr.write("Accept-Encoding : gzip, deflate\r\n");
            bWr.write("User-Agent: Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.3) Gecko/20070417 Fedora/2.0.0.3-4.fc7 Firefox/2.0.0.3\r\n");
            bWr.write("Connection: close\r\n");
            bWr.write("\r\n");
            bWr.write(this.postData);
            bWr.flush();
            BufferedReader bRd = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            String line = "";
            response = new StringBuffer("");
            while ((line = bRd.readLine()) != null) {
                response.append(line).append("\r\n");
            }
            this.responseData = response.toString();
            if (this.noHeaders) {
                this.responseData = this.responseData.substring(this.responseData.indexOf("\r\n\r\n") + 4);
            }
            bWr.close();
            bRd.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setConnectionProblems(true);
            this.setFoundErrors(true);
            this.setErrorMessage("Failed making connection to Server! (" + this.hostName + ")");
        }
    }

    public boolean isConnectionProblems() {
        return this.connectionProblems;
    }

    public void setConnectionProblems(boolean connectionProblems) {
        this.connectionProblems = connectionProblems;
    }

    public static String encode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static String executeCultService(String webHost, int port, String webURL, String data) {
        ByteArrayInputStream arrayInputStream = null;
        StringBuilder xmlRes = new StringBuilder();
        try {
            String line;
            Socket s = new Socket(webHost, port);
            BufferedReader rd = new BufferedReader(new InputStreamReader(s.getInputStream()));
            BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(s.getOutputStream(), "UTF8"));
            String encodeData = URLEncoder.encode("otaRQ", "UTF-8") + "=" + URLEncoder.encode(data.trim(), "UTF-8");
            wr.write("POST /" + webURL + " HTTP/1.0\n");
            wr.write("Host: " + webHost + "\r\n");
            wr.write("Content-Length: " + encodeData.trim().length() + "\n");
            wr.write("Content-Type: application/x-www-form-urlencoded\n");
            wr.write("\n");
            wr.write(encodeData.trim());
            wr.flush();
            while ((line = rd.readLine()) != null) {
                xmlRes.append(line + "\n");
            }
            xmlRes.delete(0, xmlRes.indexOf("<?xml"));
            xmlRes.delete(xmlRes.indexOf("<?xml"), xmlRes.indexOf("?>") + 2);
            arrayInputStream = new ByteArrayInputStream(xmlRes.toString().getBytes());
            wr.close();
            rd.close();
        }
        catch (NoRouteToHostException ne) {
            return "noInternet";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xmlRes.toString();
    }
}

