/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.spi;

import java.io.Serializable;
import java.util.Arrays;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.ValueHolder;
import org.hibernate.internal.util.compare.EqualsHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.Type;

public class NaturalIdCacheKey
implements Serializable {
    private final Serializable[] naturalIdValues;
    private final String entityName;
    private final String tenantId;
    private final int hashCode;
    private final ValueHolder<String> toString;

    public NaturalIdCacheKey(final Object[] naturalIdValues, EntityPersister persister, SessionImplementor session) {
        this.entityName = persister.getRootEntityName();
        this.tenantId = session.getTenantIdentifier();
        this.naturalIdValues = new Serializable[naturalIdValues.length];
        SessionFactoryImplementor factory = session.getFactory();
        int[] naturalIdPropertyIndexes = persister.getNaturalIdentifierProperties();
        Type[] propertyTypes = persister.getPropertyTypes();
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entityName == null ? 0 : this.entityName.hashCode());
        result = 31 * result + (this.tenantId == null ? 0 : this.tenantId.hashCode());
        for (int i = 0; i < naturalIdValues.length; ++i) {
            Type type = propertyTypes[naturalIdPropertyIndexes[i]];
            Object value = naturalIdValues[i];
            result = 31 * result + (value != null ? type.getHashCode(value, factory) : 0);
            this.naturalIdValues[i] = type.disassemble(value, session, null);
        }
        this.hashCode = result;
        this.toString = new ValueHolder<1>(new ValueHolder.DeferredInitializer<String>(){

            @Override
            public String initialize() {
                StringBuilder toStringBuilder = new StringBuilder(NaturalIdCacheKey.this.entityName).append("##NaturalId[");
                for (int i = 0; i < naturalIdValues.length; ++i) {
                    toStringBuilder.append(naturalIdValues[i]);
                    if (i + 1 >= naturalIdValues.length) continue;
                    toStringBuilder.append(", ");
                }
                toStringBuilder.append("]");
                return toStringBuilder.toString();
            }
        });
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Serializable[] getNaturalIdValues() {
        return this.naturalIdValues;
    }

    public String toString() {
        return this.toString.getValue();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.hashCode != o.hashCode() || !(o instanceof NaturalIdCacheKey)) {
            return false;
        }
        NaturalIdCacheKey other = (NaturalIdCacheKey)o;
        return this.entityName.equals(other.entityName) && EqualsHelper.equals(this.tenantId, other.tenantId) && Arrays.deepEquals(this.naturalIdValues, other.naturalIdValues);
    }
}

