package com.onlinetutorialspoint;

import com.onlinetutorialspoint.entity.Item;
import com.onlinetutorialspoint.util.HibernateUtil;
import org.hibernate.Session;
import org.hibernate.Transaction;

import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import java.util.List;
import java.util.stream.IntStream;

public class HibernatePagination {
    public static void main(String[] args) {
        //insertItems();
        //paginationUsingHQL();
        //paginationUsingCriteria();
        readEntireDataByPagination();
    }
    public static void insertItems(){
        Transaction transaction =  null;
        try(Session session = HibernateUtil.getSessionFactory().openSession() ) {
            transaction = session.beginTransaction();
            IntStream.range(0, 100).forEach(count -> {
                session.save(new Item("Item" + count, "Item" + count + "Desc", count));
            });
            transaction.commit();

        } catch (Exception e) {
            if(transaction != null && transaction.isActive())
                transaction.rollback();
            throw e;
        }
    }

    private static void paginationUsingCriteria() {
        try (Session session = HibernateUtil.getSessionFactory().openSession()) {
            int pageSize = 15;

            CriteriaBuilder criteriaBuilder = session.getCriteriaBuilder();
            CriteriaQuery<Item> criteriaQuery = criteriaBuilder.createQuery(Item.class);
            Root<Item> root = criteriaQuery.from(Item.class);

            CriteriaQuery<Item> selectQuery = criteriaQuery.select(root);
            TypedQuery<Item> typedQuery = session.createQuery(selectQuery);

            // setting pagination limits
            typedQuery.setFirstResult(10);
            typedQuery.setMaxResults(pageSize);

            printItems(typedQuery.getResultList());

        }catch(Exception e){
            e.printStackTrace();
        }
    }

    private static void printItems(List<Item> itemsList) {
        itemsList.forEach(System.out::println);
    }

    private static void paginationUsingHQL() {
        try (Session session = HibernateUtil.getSessionFactory().openSession()) {
            Query query = session.createQuery("From Item");
            int pageSize = 20;
            query.setFirstResult(10);
            query.setMaxResults(pageSize);
            printItems(query.getResultList());
        }catch(Exception e){
            e.printStackTrace();
        }
    }

    private static void readEntireDataByPagination() {
        try (Session session = HibernateUtil.getSessionFactory().openSession()) {
            int pageNumber = 1;
            int pageSize = 10;

            CriteriaBuilder criteriaBuilder = session.getCriteriaBuilder();
            CriteriaQuery<Long> countQuery = criteriaBuilder.createQuery(Long.class);

            countQuery.select(criteriaBuilder.count(countQuery.from(Item.class)));
            Long count = session.createQuery(countQuery).getSingleResult();

            CriteriaQuery<Item> criteriaQuery = criteriaBuilder.createQuery(Item.class);
            Root<Item> root = criteriaQuery.from(Item.class);
            CriteriaQuery<Item> selectQuery = criteriaQuery.select(root);

            TypedQuery<Item> typedQuery = session.createQuery(selectQuery);
            while (pageNumber < count.intValue()) {
                System.out.println("Page: " +(pageNumber/pageSize));
                typedQuery.setFirstResult(pageNumber - 1);
                typedQuery.setMaxResults(pageSize);

                printItems(typedQuery.getResultList());
                pageNumber += pageSize;

                System.out.println("==========================");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
