package com.onlinetutorialspoint;

import com.onlinetutorialspoint.util.HibernateUtil;
import com.onlinetutorialspoint.entity.Item;
import com.onlinetutorialspoint.intereptor.CrudInterceptor;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class HibernateInterceptorExample {
    public static void main(String[] args) {
        Transaction transaction = null;
        try (Session session = HibernateUtil.getSessionFactory()
                .withOptions()
                .interceptor(new CrudInterceptor())
                .openSession()) {
            transaction = session.beginTransaction();
            Item item = new Item();
            item.setItemName("iPhobeX");
            item.setItemCategory("Mobiles");
            item.setItemPrice(120000.00);
            // calling save
            session.save(item);
            transaction.commit();
            // calling load method multiple times
            Item item1 = (Item) session.load(Item.class, 1701);
            Item item2 = session.load(Item.class, 1702);
            Item item3 = session.load(Item.class, 1703);
            System.out.println("item1: " + item1);
            System.out.println("item2: " + item2);
            System.out.println("item3: " + item3);
            // Calling delete
            session.delete(item);

        } catch (Exception e) {
            e.printStackTrace();
            if (transaction != null && transaction.isActive()) {
                transaction.rollback();
                throw e;
            }
        }
    }
}
