package com.onlinetutorialspoint.intereptor;

import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;

import java.io.Serializable;

public class CrudInterceptor extends EmptyInterceptor {

    private static int loadscount;

    @Override
    public boolean onLoad(
            Object entity,
            Serializable id,
            Object[] state,
            String[] propertyNames,
            Type[] types) {
        loadscount++;
        System.out.println("Onload Method Called : " + entity + " SerializableId: " + id + " state: " + state);
        System.out.println("Load method called " + loadscount + " times");
        return super.onLoad(entity, id, state, propertyNames, types);
    }

    @Override
    public boolean onSave(
            Object entity,
            Serializable id,
            Object[] state,
            String[] propertyNames,
            Type[] types) {
        System.out.println("Onsave Method Called for : " + entity + " SerializableId: " + id + " state: " + state);
        return super.onLoad(entity, id, state, propertyNames, types);
    }

    @Override
    public void onDelete(
            Object entity,
            Serializable id,
            Object[] state,
            String[] propertyNames,
            Type[] types) {
        System.out.println("Ondelete Method Called: " + entity + " SerializableId: " + id + " state: " + state);
    }
}
