/*
 * Decompiled with CFR 0.152.
 */
package com.onlinetutorialspoint.config;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public class HibernateConnector {
    private static HibernateConnector me;
    private Configuration cfg = new Configuration().configure();
    private SessionFactory sessionFactory = this.cfg.buildSessionFactory();

    private HibernateConnector() throws HibernateException {
    }

    public static synchronized HibernateConnector getInstance() throws HibernateException {
        if (me == null) {
            me = new HibernateConnector();
        }
        return me;
    }

    public Session getSession() throws HibernateException {
        Session session = this.sessionFactory.openSession();
        if (!session.isConnected()) {
            this.reconnect();
        }
        return session;
    }

    private void reconnect() throws HibernateException {
        this.sessionFactory = this.cfg.buildSessionFactory();
    }
}

