import java.util.Iterator;
import java.util.List;

import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

import com.otp.hibernate.pojo.Customer;
import com.otp.hibernate.pojo.HibernateUtility;

public class Main {

	public static void main(String[] args) {
		SessionFactory factory = HibernateUtility.getSessionFactory();
		Session openSession = factory.openSession();
		System.out.println("*********SQL SELECT***********");
		Query query = openSession.getNamedQuery("sql_select");
		List list = query.list();
		Iterator iterator = list.iterator();
		while (iterator.hasNext()) {
			Object[] object = (Object[]) iterator.next();
			System.out.println("cId : " + object[0] + " cName : " + object[1]
					+ " cCity : " + object[2]);
		}

		System.out.println("*********sql_select_with_param***********");
		Query query5 = openSession.getNamedQuery("sql_select_with_param")
				.setString(0, "1002");
		List list5 = query5.list();
		Iterator iterator5 = list5.iterator();
		while (iterator5.hasNext()) {
			Object[] object = (Object[]) iterator5.next();
			System.out.println("cId : " + object[0] + " cName : " + object[1]
					+ " cCity : " + object[2]);
		}

		System.out.println("*********HQL SELECT***********");
		Query query2 = openSession.getNamedQuery("hql_select");
		List list2 = query2.list();
		Iterator iterator2 = list2.iterator();
		while (iterator2.hasNext()) {
			Customer customer = (Customer) iterator2.next();
			System.out.println("cId : " + customer.getCustomerId()
					+ " cName : " + customer.getCustomerName() + " cCity : "
					+ customer.getCustomerCity());
		}

		System.out.println("*********hql_select_with_param***********");
		Query query3 = openSession.getNamedQuery("hql_select_with_param")
				.setString(0, "1002");
		List list3 = query3.list();
		Iterator iterator3 = list3.iterator();
		while (iterator3.hasNext()) {
			Customer customer = (Customer) iterator3.next();
			System.out.println("cId : " + customer.getCustomerId()
					+ " cName : " + customer.getCustomerName() + " cCity : "
					+ customer.getCustomerCity());
		}

		System.out.println("*********hql_select_with_named_param***********");
		Query query4 = openSession.getNamedQuery("hql_select_with_named_param")
				.setString("cId", "1003");
		List list4 = query4.list();
		Iterator iterator4 = list4.iterator();
		while (iterator4.hasNext()) {
			Customer customer = (Customer) iterator4.next();
			System.out.println("cId : " + customer.getCustomerId()
					+ " cName : " + customer.getCustomerName() + " cCity : "
					+ customer.getCustomerCity());
		}
	}

}
