import java.util.Iterator;
import java.util.List;

import org.hibernate.Filter;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.type.IntegerType;
import org.hibernate.type.StringType;

import com.otp.hibernate.pojo.Student;

public class Main {

	public static void main(String[] args) {
		Configuration configuration = new Configuration()
				.configure("hibernate.cfg.xml");
		StandardServiceRegistryBuilder builder = new StandardServiceRegistryBuilder()
				.applySettings(configuration.getProperties());
		SessionFactory factory = configuration.buildSessionFactory(builder
				.build());

		Session session = factory.openSession();
		String qry = "select * from student";
		SQLQuery sqlQuery = session.createSQLQuery(qry);

		List list = sqlQuery.list();

		Iterator iterator = list.iterator();

		while (iterator.hasNext()) {
			Object[] object = (Object[]) iterator.next();
			System.out.println("sId : " + object[0] + " sName : " + object[1]
					+ " age : " + object[2]);
		}

		// addEntity
		System.out.println("***********Entity*************");
		String qry2 = "select * from student";
		SQLQuery sqlQuery2 = session.createSQLQuery(qry2);
		sqlQuery2.addEntity(Student.class);

		List list2 = sqlQuery2.list();
		Iterator iterator2 = list2.iterator();

		while (iterator2.hasNext()) {
			Student student = (Student) iterator2.next();
			System.out.println("sId : " + student.getStudentId() + " sName : "
					+ student.getStudentName() + " age : " + student.getAge());
		}

		// addSclar
		System.out.println("***********SCALAR*************");

		String qry3 = "select * from student";
		SQLQuery sqlQuery3 = session.createSQLQuery(qry3);

		sqlQuery3.addScalar("sid", IntegerType.INSTANCE);
		sqlQuery3.addScalar("sname", StringType.INSTANCE);

		List list3 = sqlQuery3.list();
		Iterator iterator3 = list3.iterator();

		while (iterator3.hasNext()) {
			Object[] object = (Object[]) iterator3.next();
			System.out.println("sId : " + object[0] + " sName : " + object[1]);
		}

		// update
		System.out.println("**********Update**********");

		Transaction transaction = session.beginTransaction();
		String qry4 = "update student set age=:age where sid=:id";
		SQLQuery sqlQuery4 = session.createSQLQuery(qry4);
		sqlQuery4.setParameter("id", 2);
		sqlQuery4.setParameter("age", 40);
		sqlQuery4.executeUpdate();

		transaction.commit();
		System.out.println("Completed");
		session.clear();
		session.close();
	}

}
