/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.onlinetutorialspoint.controllers;

import com.onlinetutorialspoint.dao.LoginDAO;
import com.onlinetutorialspoint.model.LoginModel;
import com.onlinetutorialspoint.service.Login;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 *
 * @author chandrashekhar
 */
@Controller
@RequestMapping("login.htm")
public class LoginController {

    @Autowired
    LoginDAO loginDAO;

    @RequestMapping(method = RequestMethod.GET)
    public String init(ModelMap modelMap) {
        modelMap.put("info", "Hello User");
        return "Login";
    }

    @RequestMapping(method = RequestMethod.POST)
    public String submit(ModelMap modelMap, @ModelAttribute("loginModel") @Valid LoginModel loginModel) {
        String password = loginModel.getPassword();
        String userName = loginModel.getUserName();
        if (password != null && userName != null) {
            Login userDetails = loginDAO.getUserDetails(loginModel.getUserName());
            if (userDetails != null && userDetails.getUserName().trim().equals(userName)
                    && userDetails.getPassword().trim().equals(password)) {
                modelMap.put("userDetails", userDetails);
                return "Home";
            } else {
                modelMap.put("error", "Invalid UserName / Password");
                return "Login";
            }
        } else {
            modelMap.put("error", "Invalid UserName / Password");
            return "Login";
        }
    }
}
