/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class HandlerMethod {
    protected final Log logger = LogFactory.getLog(HandlerMethod.class);
    private final Object bean;
    private final Method method;
    private final BeanFactory beanFactory;
    private final MethodParameter[] parameters;
    private final Method bridgedMethod;

    public HandlerMethod(Object bean, Method method) {
        Assert.notNull((Object)bean, (String)"bean must not be null");
        Assert.notNull((Object)method, (String)"method must not be null");
        this.bean = bean;
        this.beanFactory = null;
        this.method = method;
        this.bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)method);
        this.parameters = this.initMethodParameters();
    }

    public HandlerMethod(Object bean, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Assert.notNull((Object)bean, (String)"bean must not be null");
        Assert.notNull((Object)methodName, (String)"method must not be null");
        this.bean = bean;
        this.beanFactory = null;
        this.method = bean.getClass().getMethod(methodName, parameterTypes);
        this.bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)this.method);
        this.parameters = this.initMethodParameters();
    }

    public HandlerMethod(String beanName, BeanFactory beanFactory, Method method) {
        Assert.hasText((String)beanName, (String)"beanName must not be null");
        Assert.notNull((Object)beanFactory, (String)"beanFactory must not be null");
        Assert.notNull((Object)method, (String)"method must not be null");
        Assert.isTrue((boolean)beanFactory.containsBean(beanName), (String)("Bean factory [" + beanFactory + "] does not contain bean [" + beanName + "]"));
        this.bean = beanName;
        this.beanFactory = beanFactory;
        this.method = method;
        this.bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)method);
        this.parameters = this.initMethodParameters();
    }

    protected HandlerMethod(HandlerMethod handlerMethod) {
        Assert.notNull((Object)handlerMethod, (String)"HandlerMethod must not be null");
        this.bean = handlerMethod.bean;
        this.beanFactory = handlerMethod.beanFactory;
        this.method = handlerMethod.method;
        this.bridgedMethod = handlerMethod.bridgedMethod;
        this.parameters = handlerMethod.parameters;
    }

    private HandlerMethod(HandlerMethod handlerMethod, Object handler) {
        Assert.notNull((Object)handlerMethod, (String)"handlerMethod must not be null");
        Assert.notNull((Object)handler, (String)"handler must not be null");
        this.bean = handler;
        this.beanFactory = handlerMethod.beanFactory;
        this.method = handlerMethod.method;
        this.bridgedMethod = handlerMethod.bridgedMethod;
        this.parameters = handlerMethod.parameters;
    }

    private MethodParameter[] initMethodParameters() {
        int count = this.bridgedMethod.getParameterTypes().length;
        MethodParameter[] result = new MethodParameter[count];
        for (int i = 0; i < count; ++i) {
            result[i] = new HandlerMethodParameter(i);
        }
        return result;
    }

    public Object getBean() {
        return this.bean;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getBeanType() {
        Class clazz = this.bean instanceof String ? this.beanFactory.getType((String)this.bean) : this.bean.getClass();
        return ClassUtils.getUserClass((Class)clazz);
    }

    protected Method getBridgedMethod() {
        return this.bridgedMethod;
    }

    public MethodParameter[] getMethodParameters() {
        return this.parameters;
    }

    public MethodParameter getReturnType() {
        return new HandlerMethodParameter(-1);
    }

    public MethodParameter getReturnValueType(Object returnValue) {
        return new ReturnValueMethodParameter(returnValue);
    }

    public boolean isVoid() {
        return Void.TYPE.equals(this.getReturnType().getParameterType());
    }

    public <A extends Annotation> A getMethodAnnotation(Class<A> annotationType) {
        return (A)AnnotationUtils.findAnnotation((Method)this.method, annotationType);
    }

    public HandlerMethod createWithResolvedBean() {
        Object handler = this.bean;
        if (this.bean instanceof String) {
            String beanName = (String)this.bean;
            handler = this.beanFactory.getBean(beanName);
        }
        return new HandlerMethod(this, handler);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof HandlerMethod) {
            HandlerMethod other = (HandlerMethod)obj;
            return this.bean.equals(other.bean) && this.method.equals(other.method);
        }
        return false;
    }

    public int hashCode() {
        return this.bean.hashCode() * 31 + this.method.hashCode();
    }

    public String toString() {
        return this.method.toGenericString();
    }

    private class HandlerMethodParameter
    extends MethodParameter {
        public HandlerMethodParameter(int index) {
            super(HandlerMethod.this.bridgedMethod, index);
        }

        public Class<?> getContainingClass() {
            return HandlerMethod.this.getBeanType();
        }

        public <T extends Annotation> T getMethodAnnotation(Class<T> annotationType) {
            return HandlerMethod.this.getMethodAnnotation(annotationType);
        }
    }

    private class ReturnValueMethodParameter
    extends HandlerMethodParameter {
        private final Object returnValue;

        public ReturnValueMethodParameter(Object returnValue) {
            super(-1);
            this.returnValue = returnValue;
        }

        public Class<?> getParameterType() {
            return this.returnValue != null ? this.returnValue.getClass() : super.getParameterType();
        }
    }
}

