import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.AnnotationConfiguration;

import com.onlinetutorialspoint.bean.Salaries;

public class Main {
    private static final SessionFactory concreteSessionFactory;
    static {
        try {
            concreteSessionFactory = new AnnotationConfiguration()
                    .configure().buildSessionFactory();
        } catch (Throwable ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }
    public static Session getSession()
            throws HibernateException {
        return concreteSessionFactory.openSession();
    }

    public static void main(String[] args) {
        Session session=getSession();
        Transaction tx = session.beginTransaction();
        Salaries salaries = new Salaries();
        salaries.setEmpName("Rahul");
        salaries.setBasic(10000);
        salaries.setConveyance(3000);
        salaries.setHra(7000);
        session.save(salaries);
        tx.commit();
        
        Salaries d=  (Salaries)session.get(Salaries.class,new Integer(3));    
        
        System.out.println("Employee Total Salary :"+d.getTotal());

    }

}