/*
 * Decompiled with CFR 0.152.
 */
package com.onlinetutorialspoint.config;

import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.orm.hibernate4.HibernateTransactionManager;
import org.springframework.orm.hibernate4.LocalSessionFactoryBean;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class DBConfiguration {
    @Value(value="${db.driver}")
    private String DB_DRIVER;
    @Value(value="${db.password}")
    private String DB_PASSWORD;
    @Value(value="${db.url}")
    private String DB_URL;
    @Value(value="${db.username}")
    private String DB_USERNAME;
    @Value(value="${hibernate.dialect}")
    private String HIBERNATE_DIALECT;
    @Value(value="${hibernate.show_sql}")
    private String HIBERNATE_SHOW_SQL;
    @Value(value="${hibernate.hbm2ddl.auto}")
    private String HIBERNATE_HBM2DDL_AUTO;
    @Value(value="${entitymanager.packagesToScan}")
    private String ENTITYMANAGER_PACKAGES_TO_SCAN;

    @Bean
    public DataSource dataSource() {
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setDriverClassName(this.DB_DRIVER);
        dataSource.setUrl(this.DB_URL);
        dataSource.setUsername(this.DB_USERNAME);
        dataSource.setPassword(this.DB_PASSWORD);
        return dataSource;
    }

    @Bean
    public LocalSessionFactoryBean sessionFactory() {
        LocalSessionFactoryBean sessionFactoryBean = new LocalSessionFactoryBean();
        sessionFactoryBean.setDataSource(this.dataSource());
        sessionFactoryBean.setPackagesToScan(new String[]{this.ENTITYMANAGER_PACKAGES_TO_SCAN});
        Properties hibernateProperties = new Properties();
        hibernateProperties.put("hibernate.dialect", this.HIBERNATE_DIALECT);
        hibernateProperties.put("hibernate.show_sql", this.HIBERNATE_SHOW_SQL);
        hibernateProperties.put("hibernate.hbm2ddl.auto", this.HIBERNATE_HBM2DDL_AUTO);
        sessionFactoryBean.setHibernateProperties(hibernateProperties);
        return sessionFactoryBean;
    }

    @Bean
    public HibernateTransactionManager transactionManager() {
        HibernateTransactionManager transactionManager = new HibernateTransactionManager();
        transactionManager.setSessionFactory(this.sessionFactory().getObject());
        return transactionManager;
    }
}

