package com.onlinetutorialspoint.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("producer")
public class HelloController {

    @Autowired
    KafkaTemplate<String,String> KafkaTemplate;
    String TOPIC_NAME = "hello-topic";

    @GetMapping("/say/{msg}")
    public String postMessage(@PathVariable("msg") String msg){
        KafkaTemplate.send(TOPIC_NAME,msg);
        return "Message published successfully";
    }
}
